/*
 * Decompiled with CFR 0.152.
 */
package cds.allsky;

public enum ModeOverlay {
    overlayNone,
    overlayMean,
    overlayFading,
    overlayAdd;


    public static ModeOverlay getDefault() {
        return overlayMean;
    }

    public static String contains(String test) {
        if (test == null) {
            return null;
        }
        test = test.toUpperCase();
        for (ModeOverlay c : ModeOverlay.values()) {
            if (!c.name().toUpperCase().endsWith(test)) continue;
            return c.name();
        }
        return null;
    }

    public static String list() {
        StringBuilder s = new StringBuilder();
        for (ModeOverlay m : ModeOverlay.values()) {
            if (s.length() > 0) {
                s.append('|');
            }
            s.append(m.toString());
        }
        return s.toString();
    }

    public static String getExplanation(ModeOverlay m) {
        if (m == overlayNone) {
            return (Object)((Object)m) + ": Take only one progenitor pixel value";
        }
        if (m == overlayMean) {
            return (Object)((Object)m) + ": Mean of the progenitor pixel values";
        }
        if (m == overlayFading) {
            return (Object)((Object)m) + ": Mean of the progenitor pixel values + fading effect";
        }
        if (m == overlayAdd) {
            return (Object)((Object)m) + ": Addition of the progenitor pixel values";
        }
        return "";
    }
}

